# 시뮬레이션

시뮬레이션을 사용하면 실제 농장의 상태를 바꾸지 않고 코드를 빠르게 테스트할 수 있어요.
시뮬레이션의 시작 상태는 자유롭게 선택할 수 있으며, 시뮬레이션이 끝나면 실제 농장은 시뮬레이션 시작 전과 똑같은 상태가 돼요.

`simulate()` 함수는 시뮬레이션을 시작하는 데 사용돼요.

실행을 시작할 파일
`filename = "f1"`

모든 것을 해금하고 완전히 업그레이드한 상태로 시작
`sim_unlocks = Unlocks`

당근 10000개와 건초 50개로 시작
`sim_items = {Items.Carrot : 10000, Items.Hay : 50}`

값이 13인 전역 변수 "a"로 시작
`sim_globals = {"a" : 13}`

고정된 랜덤 시드 사용
`seed = 0`

시뮬레이션 속도를 64배로 높임
`speedup = 64`

시뮬레이션 실행
`run_time = simulate(filename, sim_unlocks, sim_items, sim_globals, seed, speedup)`

`simulate()` 함수는 주어진 시작 파일을 시뮬레이션하는 데 걸린 시간(초)을 반환해요.

### 파일 이름
`simulate` 함수의 첫 번째 인수는 파일 이름이에요. 이것은 코드 창 상단에 표시되는 이름이에요. 시뮬레이션은 마치 실행 버튼을 클릭한 것처럼 지정된 파일을 실행할 거예요.

### 시작 해금 요소
루프, if문, 리스트, 딕셔너리 같은 모든 프로그래밍 기능은 항상 해금된 상태로 유지돼요. 

두 번째 인수는 프로그래밍 기능 외에 시뮬레이션을 시작할 때 어떤 해금/업그레이드를 사용할지 지정할 수 있게 해줘요. 이것은 해금 요소의 시퀀스여야 해요. 시뮬레이션은 시퀀스에 있는 모든 해금 요소가 최대 레벨로 업그레이드된 상태로 시작돼요.

최대 레벨이 아닌 다른 업그레이드 레벨을 지정하고 싶다면, 해금 요소를 해금 레벨에 매핑하는 딕셔너리를 전달할 수 있어요. 이 경우, 음수 값은 최대 해금 레벨에 해당해요.

### 시작 아이템
세 번째 인수는 아이템을 숫자에 매핑하는 딕셔너리를 전달할 수 있게 해줘요. 시뮬레이션을 시작할 아이템을 지정해요.

### 시작 전역 변수
시뮬레이션은 완전히 새로운 프로그램 실행을 시작하기 때문에, 시뮬레이션을 시작하는 프로그램의 변수에 접근할 수 없어요.
하지만 네 번째 인수를 사용하여 시뮬레이션에 값을 전달할 수 있어요. 이것은 변수 이름을 문자열 형태로 값에 매핑하는 딕셔너리예요. 이 변수들은 시뮬레이션 내 실행의 전역 범위에 추가돼요.

이것은 모든 값을 복사하므로, 시뮬레이션 내에서 값을 변경해도 시뮬레이션 밖의 원래 값에는 영향을 주지 않아요. 실행에 걸린 시간 외에는 시뮬레이션에서 값을 반환할 수 없어요.

### 랜덤 시드
다섯 번째 인수는 시뮬레이션에서 사용할 랜덤 시드를 지정할 수 있게 해줘요. 이것은 양의 정수여야 해요. 음수 값은 무작위 시드를 사용하게 해요.

랜덤 시드는 식물 성장 시간부터 미로 배치, 물 감소 시간까지 모든 것에 영향을 줘요. 동일한 랜덤 시드와 동일한 시작 조건으로 같은 시뮬레이션을 여러 번 시작하면 결과는 항상 같아야 해요.

### 속도 배율
여섯 번째 인수는 시뮬레이션의 시작 속도 배율이에요. 이것으로 여러 가지를 빠르게 테스트할 수 있어요. 게임이 설정된 속도를 따라가지 못하면 자동으로 속도가 느려져요.

속도 배율은 시뮬레이션 결과에 어떤 영향도 주지 않아요. 오직 대기 시간을 줄이기 위해 존재해요.